#include <bits/stdc++.h>

#define pb push_back
#define MAXN 10000010

using namespace std;

bool prime[MAXN];
vector<int> primes;

void erathostenes() {

    memset(prime, true, sizeof(prime));

    prime[1] = false;

    for(int j = 4; j < MAXN; j += 2)
        prime[j] = false;

    for(int i = 3; i * i < MAXN; i += 2) {
        if(!prime[i])
            continue;
        for(int j = i * i; j < MAXN; j += i)
            prime[j] = false;
    }

    primes.pb(2);
    for(int i = 3; i < MAXN; i += 2)
        if(prime[i])
            primes.pb(i);
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    erathostenes();

    int q;
    cin >> q;
    while(q--) {
        int n;
        cin >> n;

        int len = (upper_bound(primes.begin(), primes.end(), n)
            - upper_bound(primes.begin(), primes.end(), n / 2));
        cout << n - 1 - len << endl;
    }
    return 0;
}